package com.artstore.item;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.GenericGenerator;

import com.artstore.account.Account;
import com.artstore.economy.payment.Payment;
import com.artstore.status.OrderStatus;

@Entity
@Table(name="`orders`")
public class Order implements Serializable
{
	private static final long serialVersionUID = -1377653868766945443L;

	@Id
	@GeneratedValue(generator = "UUID")
	@GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(columnDefinition = "BINARY(16)", updatable = false, nullable = false)
	private UUID id;
	
	private String title;
	
	@Column(name = "creationDate", nullable = false)
	@CreationTimestamp
	private Date	creationDate;
	
	@Convert(converter = OrderStatus.OrderStatusConverter.class)
	private OrderStatus status;
	
	@OneToOne(targetEntity=Account.class)
	private Account purchaser;
	
	@OneToOne(targetEntity=Payment.class)
	private Payment payment;
	
	@OneToMany(targetEntity=Item.class)
	private List<Item> items;
	
	public Order() { }

	public UUID getId()
	{
		return id;
	}

	public void setId(UUID id)
	{
		this.id = id;
	}

	public String getTitle()
	{
		return title;
	}

	public void setTitle(String orderTitle)
	{
		this.title = orderTitle;
	}

	public Date getCreationDate()
	{
		return creationDate;
	}

	public void setCreationDate(Date creationDate)
	{
		this.creationDate = creationDate;
	}

	public OrderStatus getOrderStatus()
	{
		return status;
	}

	public void setOrderStatus(OrderStatus orderStatus)
	{
		this.status = orderStatus;
	}

	public Account getPurchaser()
	{
		return purchaser;
	}

	public void setPurchaser(Account purchaser)
	{
		this.purchaser = purchaser;
	}

	public Payment getPayment()
	{
		return payment;
	}

	public void setPayment(Payment payment)
	{
		this.payment = payment;
	}

	public List<Item> getOrderedItems()
	{
		return items;
	}

	public void setOrderedItems(List<Item> orderedItems)
	{
		this.items = orderedItems;
	}
}
