package com.artstore.item;

import javax.persistence.AttributeConverter;

public enum ItemType
{	
	Sculpture(0, "Rzeźba"),
	Picture(1, "Obraz"),
	Mosaic(2, "Mozaika"),
	Mural(3, "Fototapeta");
	
	int id;
	String type;
	
	ItemType(int id, String type)
	{
		this.id = id;
		this.type = type;
	}
	
	public int GetID()
	{
		return id;
	}
	
	public String GetType()
	{
		return type;
	}
	
	public static class ItemTypeConverter implements AttributeConverter<ItemType, Integer>
	{
		@Override
		public Integer convertToDatabaseColumn(ItemType attribute)
		{
			return attribute == null ? -1 : attribute.GetID();
		}

		@Override
		public ItemType convertToEntityAttribute(Integer dbData)
		{
			if(dbData == null) { return null; }
			
			for(ItemType itemType : ItemType.values())
			{
				if(dbData.equals(itemType.GetID()))
				{
					return itemType;
				}
			}
			
			return null;
		}
	}
}