package com.artstore.item;

import java.util.List;
import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;

import com.artstore.Core;
import com.artstore.managers.AbstractManager;
import com.artstore.managers.IItemManager;
import com.artstore.repositories.ItemRepository;
import com.querydsl.core.BooleanBuilder;

@Component
public class ItemManager extends AbstractManager implements IItemManager
{
	private ItemRepository itemRepo;

	@Autowired
	public ItemManager(Core core, ItemRepository itemRepo)
	{
		super(core);

		this.itemRepo = itemRepo;
	}

	@Override
	public ItemRepository GetRepo()
	{
		return itemRepo;
	}
	
	@Override
	public Item GetItem(UUID id)
	{
		return itemRepo.findById(id).orElse(null);
	}

	@Override
	public List<Item> GetItems()
	{
		return itemRepo.findAll();
	}
	
	public Page<Item> Fetch(int pageNumber, int pageSize)
	{
		return GetRepo().findAll(PageRequest.of(pageNumber, pageSize));
	}

	public Page<Item> Fetch(int pageNumber, int pageSize, String title, String author, String desc, Integer above,
			Integer below)
	{
		BooleanBuilder builder = new BooleanBuilder();
		if (title != null && !title.isEmpty())
		{
			builder.and(QItem.item.title.contains(title));
		}
		if (author != null && !author.isEmpty())
		{
			builder.and(QItem.item.author.contains(author));
		}
		if (desc != null && !desc.isEmpty())
		{
			builder.and(QItem.item.description.contains(desc));
		}
		if (below != null && above != null)
		{
			builder.and(QItem.item.price.quantity.between(above, below));
		}

		Page<Item> page = GetRepo().findAll(builder.getValue(), PageRequest.of(pageNumber, pageSize));

		return page;
	}
}
