package com.artstore.item;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.GenericGenerator;

import com.artstore.economy.Money;
import com.artstore.entity.IEntity;
import com.querydsl.core.annotations.QueryEntity;

@Entity
@Table(name = "items")
@QueryEntity
public class Item implements IEntity<UUID>, Serializable
{
	private static final long serialVersionUID = 8538150567274357874L;

	@Id
	@GeneratedValue(generator = "UUID")
	@GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(columnDefinition = "BINARY(16)", updatable = false, nullable = false)
	private UUID              id;

	private String            title;
	
	@Convert(converter = ItemType.ItemTypeConverter.class)
	private ItemType type;
	
	private String            author;
	private String            description;

	@Embedded
	private ImageData         mainImgData;

	@ElementCollection
	private List<ImageData>   imgData;

	@Column(name = "startDate", nullable = false)
	@CreationTimestamp
	private Date              startDate;

	@Embedded
	private Money             price;

	public Item()
	{
	}
	
	public UUID GetID()
	{
		return getId();
	}

	public UUID getId()
	{
		return id;
	}

	public void setId(UUID id)
	{
		this.id = id;
	}

	public String getTitle()
	{
		return title;
	}

	public void setTitle(String title)
	{
		this.title = title;
	}

	public ItemType getType()
	{
		return type;
	}

	public void setType(ItemType type)
	{
		this.type = type;
	}

	public String getAuthor()
	{
		return author;
	}

	public void setAuthor(String author)
	{
		this.author = author;
	}

	public String getDescription()
	{
		return description;
	}

	public void setDescription(String description)
	{
		this.description = description;
	}

	public ImageData getMainImgData()
	{
		return mainImgData;
	}

	public void setMainImgData(ImageData mainImgData)
	{
		this.mainImgData = mainImgData;
	}

	public List<ImageData> getImgData()
	{
		return imgData;
	}

	public void setImgData(List<ImageData> imgData)
	{
		this.imgData = imgData;
	}

	public Date getStartDate()
	{
		return startDate;
	}

	public void setStartDate(Date startDate)
	{
		this.startDate = startDate;
	}

	public Money getPrice()
	{
		return price;
	}

	public void setPrice(Money price)
	{
		this.price = price;
	}
}
