package com.artstore.event;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;

import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;

import com.artstore.Core;
import com.artstore.managers.AbstractManager;
import com.artstore.managers.IEventManager;

@Component
public class EventManager extends AbstractManager implements IEventManager
{
	private final List<Pair<IEventListener, Pair<Class<? extends IEvent>, Method>[]>> listeners = new ArrayList<>();

	public EventManager(final Core core)
	{
		super(core);
	}

	@SuppressWarnings("unchecked")
	@Override
	public boolean RegisterEventListener(IEventListener eventListener)
	{
		List<Pair<Class<? extends IEvent>, Method>> events = new ArrayList<>();
		Method[] methods = eventListener.getClass().getMethods();

		for (Method m : methods)
		{
			if (m.isAnnotationPresent(EventHandler.class))
			{
				Parameter[] params = m.getParameters();

				if (params.length == 1 && IEvent.class.isAssignableFrom(params[0].getType()))
				{
					events.add(Pair.of((Class<? extends IEvent>) params[0].getType(), m));

					continue;
				}
			}
		}

		listeners.add(Pair.of(eventListener, events.toArray(new Pair[events.size()])));

		return true;
	}

	@Override
	public boolean CallEvent(IEvent event)
	{
		for (Pair<IEventListener, Pair<Class<? extends IEvent>, Method>[]> p0 : listeners)
		{
			for (Pair<Class<? extends IEvent>, Method> p1 : p0.getSecond())
			{
				if (p1.getFirst().isAssignableFrom(event.getClass()))
				{
					try
					{
						p1.getSecond().invoke(p0.getFirst(), event);

						if ((event instanceof ICancellableEvent) && ((ICancellableEvent)event).isCancelled())
						{
							return true;
						}

					} catch (Exception ex)
					{
						ex.printStackTrace();
						
						return false;
					}
				}
			}
		}
		
		return false;
	}
}
