package com.artstore.economy.payment;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.artstore.Core;
import com.artstore.economy.Transfer;
import com.artstore.economy.event.TransferPostedEvent;
import com.artstore.economy.payment.event.PaymentFinalizedEvent;
import com.artstore.event.EventHandler;
import com.artstore.event.IEventListener;
import com.artstore.managers.AbstractManager;
import com.artstore.managers.IPaymentManager;
import com.artstore.repositories.PaymentRepository;

@Component
public class PaymentManager extends AbstractManager implements IEventListener, IPaymentManager
{
	PaymentRepository paymentRepo;
	
	@Autowired
	public PaymentManager(Core core, PaymentRepository paymentRepo)
	{
		super(core);
		
		this.paymentRepo = paymentRepo;
	}
	
	@Override
	public boolean Initialize()
	{
		return super.Initialize();
	}

	@Override
	public boolean Dispose()
	{
		return super.Dispose();
	}
	
	@EventHandler
	public void onTransferPosted(TransferPostedEvent ev)
	{
		for(Payment payment : ev.GetSource().getWaitingPayments())
		{
			if(UpdatePayment(payment))
			{
				Core().GetEventManager().CallEvent(new PaymentFinalizedEvent(payment));
			}
		}
	}
	
	public Payment AddPayment(Payment newPayment)
	{
		try
		{
			return paymentRepo.saveAndFlush(newPayment);
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
		
		return null;
	}
	
	public boolean UpdatePayment(Payment payment)
	{
		if(!payment.IsFinalized())
		{
			Transfer transfer = payment.PrepareTransfer();
			
			if(Core().GetEconomyManager().PostTransfer(transfer))
			{
				payment.setTransfer(transfer);
				
				return true;
			}
		}
		
		return false;
	}
}
