package com.artstore.economy.payment;

import java.util.Date;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;

import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.GenericGenerator;

import com.artstore.economy.EconomyEntity;
import com.artstore.economy.Money;
import com.artstore.economy.Transfer;

@Entity
public class Payment
{
	@Id
	@GeneratedValue(generator = "UUID")
	@GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(columnDefinition = "BINARY(16)", updatable = false, nullable = false)
	private UUID          id;

	@Embedded
	private Money quantity;
	

	@OneToOne
	private EconomyEntity source;
	@OneToOne
	private EconomyEntity destination;

	@CreationTimestamp
	private Date          postDate;

	@OneToOne
	private Transfer      transfer;

	public Payment(Money value, EconomyEntity source, EconomyEntity destination)
	{
		this.id = null;
		this.quantity = value;
		this.source = source;
		this.destination = destination;
		this.postDate = new Date();
		this.transfer = null;
	}

	public Payment()
	{
	}

	public UUID getId()
	{
		return id;
	}

	public Money getValue()
	{
		return quantity;
	}

	public EconomyEntity getSource()
	{
		return source;
	}

	public EconomyEntity getDestination()
	{
		return destination;
	}

	public Date getPostDate()
	{
		return postDate;
	}

	public Transfer getTransfer()
	{
		return transfer;
	}

	public void setTransfer(Transfer transfer)
	{
		this.transfer = transfer;
	}
	
	public boolean IsFinalized()
	{
		return transfer != null;
	}

	public Transfer PrepareTransfer()
	{
		return new Transfer(getSource(), getDestination(), getValue());
	}
}
