package com.artstore.economy.event;

import com.artstore.economy.TransferRequest;
import com.artstore.event.ICancellableEvent;

public class IncomingTransferEvent implements ICancellableEvent
{
	boolean processed = false;
	
	public static enum TransactionProcessResult
	{
		OK(0, "No problems"),
		BadCurrency(1, "Wrong currency");
		
		int id;
		String desc;
		
		TransactionProcessResult(int id, String desc)
		{
			this.id = id;
			this.desc = desc;
		}
	}
	
	TransferRequest request;
	
	public IncomingTransferEvent(TransferRequest request)
	{
		this.request = request;
	}
	
	public TransferRequest GetTransferRequest()
	{
		return request;
	}
	
	public boolean isProcessed()
	{
		return processed;
	}
	
	public void setProcessed()
	{
		processed = true;
	}

	@Override
	public boolean isCancelled()
	{
		return processed;
	}

	@Override
	public void setCancelled(boolean isCancelled)
	{
		
	}
}
