package com.artstore.economy;

import java.util.Date;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;

import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.GenericGenerator;

@Entity
public class Transfer
{
	@Id
	@GeneratedValue(generator = "UUID")
	@GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(columnDefinition = "BINARY(16)", updatable = false, nullable = false)
	private UUID          id;
	
	@OneToOne(targetEntity=EconomyEntity.class)
	private EconomyEntity source;
	@OneToOne(targetEntity=EconomyEntity.class)
	private EconomyEntity destination;
	
	private Money quantity;
	
	@CreationTimestamp
	private Date postDate;

	public Transfer(EconomyEntity source, EconomyEntity destination, Money monetaryValue)
	{
		this.source = source;
		this.destination = destination;
		this.quantity = monetaryValue;
	}
	public Transfer() { }
	
	public UUID getId()
	{
		return id;
	}
	public void setId(UUID id)
	{
		this.id = id;
	}
	
	public EconomyEntity getSource()
	{
		return source;
	}
	public EconomyEntity getDestination()
	{
		return destination;
	}
	public Money getMonetaryValue()
	{
		return quantity;
	}
	public Date getPostDate()
	{
		return postDate;
	}
}
