package com.artstore.economy;

import javax.persistence.Embeddable;
import javax.persistence.OneToOne;

@Embeddable
public class Money
{
	private Long quantity = 0L;
	
	@OneToOne(targetEntity=Currency.class)
	private Currency currency;
	
	public Money()
	{
		this(0L, null);
	}
	
	public Money(Long qantity, Currency currency)
	{
		this.quantity = qantity;
		this.currency = currency;
	}
	
	public Money(Currency currency)
	{
		this(0L, currency);
	}
	
	@Override
	public String toString()
	{
		return quantity + " " + currency.getSymbol();
	}
	
	public static Money Least(Money m0, Money m1)
	{
		return m0.IsGreaterThan(m1) ? m1 : m0;
	}
	
	public static Money CreateDifference(Money m0, Money m1)
	{
		if(!m0.IsCompatible(m1)) { return null; }
		
		return new Money(m0.getQuantity() < m1.getQuantity() ? (m1.getQuantity() - m0.getQuantity()) : (m0.getQuantity() - m1.getQuantity()), m0.getCurrency());
	}
	
	public Long getQuantity()
	{
		return quantity;
	}

	public void setQuantity(Long quantity)
	{
		this.quantity = quantity;
	}
	
	public void updateQuantity(Long quantitnty)
	{
		this.quantity += quantity;
	}

	public Currency getCurrency()
	{
		return currency;
	}

	public void setCurrency(Currency currency)
	{
		this.currency = currency;
	}

	public boolean IsCompatible(Money money)
	{
		return money.currency.equals(currency);
	}
	
	public boolean IsGreaterThan(Money money)
	{
		return IsCompatible(money) && money.getQuantity() <= quantity;
	}
}
