package com.artstore.economy;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.artstore.economy.payment.Payment;
import com.artstore.entity.IEntity;

@Entity
@Table(name="economyEntities")
public class EconomyEntity implements IEntity<UUID>
{
	@Id
	@GeneratedValue(generator = "UUID")
	@GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(columnDefinition = "BINARY(16)", updatable = false, nullable = false)
	private UUID id;
	
	@Column(nullable = false)
	private String transferCode;
	
	@Embedded
	private CompositeMoney value;
	
	@ManyToOne(targetEntity=Transfer.class)
	private List<Transfer> transfers = new ArrayList<>();
	@ManyToOne(targetEntity=Payment.class)
	private List<Payment> payments = new ArrayList<>();

	
	public EconomyEntity(UUID id, String transferCode)
	{
		this.id = id;
		this.transferCode = transferCode;
	}
	
	@Override
	public UUID GetID()
	{
		return id;
	}

	public String getTransferCode()
	{
		return transferCode;
	}

	public CompositeMoney getQuantities()
	{
		return value;
	}
	
	public Money Get(Currency currency)
	{
		return value.GetValue(currency);
	}

	public List<Transfer> getTransfers()
	{
		return transfers;
	}

	public List<Payment> getPayments()
	{
		return payments;
	}
	
	public List<Payment> getWaitingPayments()
	{
		return payments;
	}
}
