package com.artstore.economy;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;

@Embeddable
public class CompositeMoney
{
	@ElementCollection(targetClass=Money.class)
	private List<Money> wartosci = new ArrayList<>();
	
	public CompositeMoney()
	{
		
	}
	
	public boolean HasValue(Currency currency)
	{
		for(Money val : wartosci)
		{
			if(val.getCurrency().equals(currency))
			{
				return true;
			}
		}
		
		return false;
	}
	
	public Money GetValue(Currency currency)
	{
		for(Money val : wartosci)
		{
			if(val.getCurrency().equals(currency))
			{
				return val;
			}
		}
		
		Money res = new Money(currency);
		wartosci.add(res);
		
		return res;
	}
	
	public boolean Add(Money val)
	{
		GetValue(val.getCurrency()).updateQuantity(val.getQuantity());
		
		return true;
	}
	
	public boolean Subtract(Money val)
	{
		if(HasValue(val.getCurrency()))
		{
			Money myVal = GetValue(val.getCurrency());
			
			if(val.getQuantity() <= myVal.getQuantity())
			{
				myVal.updateQuantity(-val.getQuantity());
				
				return true;
			}
		}
		
		return false;
	}
	
	public Long GetQuantity(Currency currency)
	{
		return GetValue(currency).getQuantity();
	}
	
	public void SetQuantity(Currency currency, Long quantity)
	{
		GetValue(currency).setQuantity(quantity);
	}
	
	public void UpdateQuantity(Currency currency, Long quantity)
	{
		GetValue(currency).setQuantity(quantity);
	}
	
	public void UpdateQuantity(Money val)
	{
		UpdateQuantity(val.getCurrency(), val.getQuantity());
	}
	
	public boolean IsGreaterThan(Money money)
	{
		return HasValue(money.getCurrency()) && money.getQuantity() <= GetValue(money.getCurrency()).getQuantity();
	}
	
	
}
