package com.artstore.controllers;

import java.util.Locale;

import javax.servlet.http.HttpSession;

import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.artstore.Core;
import com.artstore.controllers.Pack.ItemPack;
import com.artstore.item.ImageManager;
import com.artstore.item.Item;

@Controller
public class WorkerController extends AbstractController
{
	public WorkerController(Core core)
	{
		super(core);
	}

	@RequestMapping(value = "/worker", method = RequestMethod.GET)
	public String worker(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		return "/worker/worker";
	}

	@RequestMapping(value = "/worker/items", method = RequestMethod.GET)
	public String items(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		Page<Item> page = Core().GetItemManager().Fetch(0, 100);
		ItemPack res = new ItemPack();
		res.setList(page.getContent());
		res.setMaxLength((int) page.getTotalPages());
		model.addAttribute("data", res);

		return "/worker/items";
	}

	@RequestMapping(value = "/worker/orders", method = RequestMethod.GET)
	public String orders(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		return "/worker/orders";
	}

	@RequestMapping(value = "/worker/mailbox", method = RequestMethod.GET)
	public String mailbox(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		return "/worker/mailbox";
	}

	@RequestMapping(value = "/worker/items/editor", method = RequestMethod.GET)
	public String itemEditor(@RequestParam(value = "item", required = false) Item item, Locale locale, Model model,
			HttpSession session, RedirectAttributes ra)
	{
		if(item != null)
		{
			model.addAttribute("item", item);
		}
		
		return "/worker/items/editor";
	}
	
	@RequestMapping(value = "/worker/items/edit", method = RequestMethod.POST)
    public String uploadingPost(@RequestParam("uploadingFiles") MultipartFile[] uploadingFiles) {
        for(MultipartFile imgFile : uploadingFiles) {
            ImageManager.Save(imgFile);
        }

        return "redirect:/";
    }
}
