package com.artstore.controllers;

import java.util.Locale;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.http.MediaType;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.artstore.account.AccountManager;
import com.artstore.account.InfoAccount;
import com.artstore.controllers.Pack.CurrencyPack;
import com.artstore.controllers.Pack.InfoAccountPack;
import com.artstore.controllers.Pack.ItemPack;
import com.artstore.economy.Currency;
import com.artstore.economy.EconomyManager;
import com.artstore.item.Item;
import com.artstore.item.ItemManager;
import com.artstore.item.QItem;
import com.querydsl.core.BooleanBuilder;

@RestController
public class RESTController
{
	@Autowired
	private AccountManager aM;
	
	@Autowired
	private ItemManager iM;
	
	@Autowired
	private EconomyManager eM;
	
	

	@RequestMapping(value = "/rest/accounts", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_VALUE)
	public InfoAccountPack accounts(@RequestParam Map<String, String> map, @RequestParam("pageNumber") int pageNumber,
			@RequestParam("pageSize") int pageSize, Locale locale, Model model, HttpSession session,
			RedirectAttributes ra)
	{
		Page<InfoAccount> page = aM.Fetch(pageNumber, pageSize);
		InfoAccountPack res = new InfoAccountPack();
		res.setList(page.getContent());
		res.setMaxLength((int) page.getTotalPages());

		return res;
	}

	@RequestMapping(value = "/rest/items", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_VALUE)
	public ItemPack items(@RequestParam Map<String, String> map, @RequestParam("pageNumber") int pageNumber,
			@RequestParam("pageSize") int pageSize, @RequestParam(value = "title", required = false) String title,
			@RequestParam(value = "author", required = false) String author,
			@RequestParam(value = "desc", required = false) String desc,
			@RequestParam(value = "above", required = false) Integer above,
			@RequestParam(value = "below", required = false) Integer below, Locale locale, Model model,
			HttpSession session, RedirectAttributes ra)
	{
		BooleanBuilder builder = new BooleanBuilder();
		if (title != null && !title.isEmpty()) {
		      builder.and(QItem.item.title.contains(title));
		    }
		if (author != null && !author.isEmpty()) {
		      builder.and(QItem.item.author.contains(author));
		    }
		if (desc != null && !desc.isEmpty()) {
		      builder.and(QItem.item.description.contains(desc));
		    }
		if (below != null && above != null) {
		      builder.and(QItem.item.price.quantity.between(above, below));
		    }
		
		Page<Item> page = iM.GetRepo().findAll(builder.getValue(),
		        PageRequest.of(pageNumber, pageSize));
		ItemPack res = new ItemPack();
		res.setList(page.getContent());
		res.setMaxLength((int) page.getTotalPages());
		
		return res;
	}
	
	@RequestMapping(value = "/rest/currencies", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_VALUE)
	public CurrencyPack currencies(@RequestParam Map<String, String> map, @RequestParam("pageNumber") int pageNumber,
			@RequestParam("pageSize") int pageSize, Locale locale, Model model, HttpSession session,
			RedirectAttributes ra)
	{
		Page<Currency> page = eM.GetCurrencyRepo().findAll(PageRequest.of(pageNumber, pageSize));
		
		CurrencyPack res = new CurrencyPack();
		res.setList(page.getContent());
		res.setMaxLength((int) page.getTotalPages());

		return res;
	}
}
