package com.artstore.controllers;

import java.util.List;

import com.artstore.account.Account;
import com.artstore.account.InfoAccount;
import com.artstore.economy.Currency;
import com.artstore.item.Item;

public abstract class Pack<T>
{
	public static class CurrencyPack extends Pack<Currency>
	{
		
	}
	
	public static class InfoAccountPack extends Pack<InfoAccount>
	{
		
	}
	
	public static class AccountPack extends Pack<Account>
	{
		
	}
	
	public static class ItemPack extends Pack<Item>
	{
		
	}
	
	int maxLength;
	List<T> list;
	
	public Pack()
	{
		super();
	}

	public int getMaxLength()
	{
		return maxLength;
	}

	public void setMaxLength(int maxLength)
	{
		this.maxLength = maxLength;
	}

	public List<T> getList()
	{
		return list;
	}

	public void setList(List<T> list)
	{
		this.list = list;
	}
}
