package com.artstore.controllers;

import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.artstore.Core;
import com.artstore.Utils;
import com.artstore.controllers.Pack.ItemPack;
import com.artstore.item.Item;

@Controller
public class NavController
{
	public static Core core;
	
	@RequestMapping(value = "/unauth", method = RequestMethod.GET)
	public static String unauth()
	{
		return "redirect:/";
	}
	
	@RequestMapping(value = "/", method = RequestMethod.GET)
	public static String index(Model model, RedirectAttributes ra)
	{
		return Utils.Info("Lol: " + core.lol, model, ra);
		//return "/index";
	}
	
	@RequestMapping(value = "/about", method = RequestMethod.GET)
	public static String about()
	{
		return "/about";
	}
	
	@RequestMapping(value = "/coop", method = RequestMethod.GET)
	public static String coop()
	{
		return "/coop";
	}
	
	@RequestMapping(value = "/contact", method = RequestMethod.GET)
	public static String contact()
	{
		return "/contact";
	}
	
	@RequestMapping(value = "/search", method = RequestMethod.GET)
	public static String search(Model model, RedirectAttributes ra)
	{
		return Utils.Info("Podstrona w budowie." , model, ra);
	}
	
	@RequestMapping(value = "/loginPanel", method = RequestMethod.GET)
	public static String loginPanel()	
	{
		return "/loginPanel";
	}
	
	@RequestMapping(value = "/loginPanel/passwordRec", method = RequestMethod.GET)
	public static String passwordRec()
	{
		return "/passwordRec";
	}
	
	@RequestMapping(value = "/loginPanel/activationMail", method = RequestMethod.GET)
	public static String activationMail(@RequestParam("username") String username, Model model)
	{
		model.addAttribute("username", username);
		
		return "/activationMail";
	}
	
	@RequestMapping(value = "/regPanel", method = RequestMethod.GET)
	public static String regPanel()
	{
		return "/regPanel";
	}
	
	@RequestMapping(value = "/info", method = RequestMethod.POST)
	public static String info(@RequestParam("info") String info, Model model)
	{
		model.addAttribute("info", info);
		
		return "/info";
	}
}
