package com.artstore.controllers;

import java.util.UUID;

import javax.servlet.http.HttpSession;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;

import com.artstore.ArtStoreApplication;
import com.artstore.account.AccountManager;
import com.artstore.account.RegistrationManager;

@Controller
public class MainController
{
	protected static boolean ValidateLoginState(HttpSession session, Model model, ModelAndView mav, boolean loginState)
	{
		AccountManager aM = ArtStoreApplication.GetAM();

		if (aM.IsLogged(session) != loginState)
		{
			mav.setView(new RedirectView("/"));
			System.out.println("Musisz być " + (loginState ? "zalogowany" : "niezalogowany") + " by móc wejść na tę podstronę.");
			model.addAttribute("returnMsg","Musisz być " + (loginState ? "zalogowany" : "niezalogowany") + " by móc wejść na tę podstronę.");
			return false;
		}

		Set(session, model);

		return true;
	}

	protected static void Set(HttpSession session, Model model)
	{
		AccountManager aM = ArtStoreApplication.GetAM();

		if (aM.IsLogged(session))
		{
			model.addAttribute("isLogged", true);

			model.addAttribute("account", aM.FetchAccount((UUID) session.getAttribute("accountUID")));
		} else
		{
			model.addAttribute("isLogged", false);
		}
	}

	@RequestMapping(value = "/about", method = RequestMethod.GET)
	public static String about(HttpSession session, Model model)
	{
		Set(session, model);

		return "/about";
	}

	@RequestMapping(value = "/account", method = RequestMethod.GET)
	public static ModelAndView account(HttpSession session, Model model, ModelAndView mav)
	{
		if (ValidateLoginState(session, model, mav, true))
		{
			mav.setViewName("/account");
		}
		
		return mav;
	}

	@RequestMapping(value = "/contact", method = RequestMethod.GET)
	public static String contact(HttpSession session, Model model, ModelAndView mav)
	{
		Set(session, model);

		return "/contact";
	}

	@RequestMapping(value = "/coop", method = RequestMethod.GET)
	public static String coop(HttpSession session, Model model, ModelAndView mav)
	{
		Set(session, model);

		return "/coop";
	}

	@RequestMapping(value = "/", method = RequestMethod.GET)
	public static String index(HttpSession session, Model model, ModelAndView mav)
	{
		Set(session, model);
		
		return "/index";
	}

	@RequestMapping(value = "/loginPanel", method = RequestMethod.GET)
	public static ModelAndView loginPanel(HttpSession session, Model model, ModelAndView mav)
	{
		if (ValidateLoginState(session, model, mav, false))
		{
			mav.setViewName("/loginPanel");
		}

		return mav;
	}
	
	@RequestMapping(value = "/loginPanel/login", method = RequestMethod.POST)
	public static ModelAndView loginPanel(HttpSession session, Model model, ModelAndView mav, @RequestParam("username") String username, @RequestParam("password") String password)
	{
		mav.setView(new RedirectView("/"));
		
		if (!ArtStoreApplication.GetAM().Login(username, password, session))
		{
			System.out.println("Błędny login lub hasło!");
			model.addAttribute("returnMsg", "Błędny login lub hasło!");
		}
		
		return mav;
	}

	@RequestMapping(value = "/registerPanel", method = RequestMethod.GET)
	public static ModelAndView registerPanel(HttpSession session, Model model, ModelAndView mav)
	{
		if (ValidateLoginState(session, model, mav, false))
		{
			mav.setViewName("/registerPanel");
		}
		
		return mav;
	}
	
	@RequestMapping(value = "/registerPanel/register", method = RequestMethod.POST)
	public static ModelAndView loginPanel(HttpSession session, Model model, ModelAndView mav, @RequestParam("username") String username, @RequestParam("password") String password, @RequestParam("password2") String password2, @RequestParam("email") String email)
	{
		if(!password.equals(password2))
		{
			System.out.println("Hasła się nie zgadzają!");
			model.addAttribute("returnMsg", "Hasła się nie zgadzają!");
		}
		else if(RegistrationManager.RegisterAccount(username, password2, email))
		{
			System.out.println("Zarejestrowano pomyślnie. Dokonaj aktywacji konta poprzez użycie linka dostarczonego na Twoją skrzynkę mailową.");
			model.addAttribute("returnMsg", "Zarejestrowano pomyślnie. Dokonaj aktywacji konta poprzez użycie linka dostarczonego na Twoją skrzynkę mailową.");
		}
		else
		{
			System.out.println("Nie można zarejestrować (nazwa użytkownika jest zajęta)");
			model.addAttribute("returnMsg", "Nie można zarejestrować (nazwa użytkownika jest zajęta)");
		}
		
		mav.setView(new RedirectView("/"));
		return mav;
	}
}
