package com.artstore.controllers;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.artstore.config.interceptors.Control;
import com.artstore.item.Item;
import com.artstore.item.ItemManager;

@Controller
public class ItemController
{
	@Autowired
	private ItemManager iM;

	@RequestMapping(value = "/items", method = RequestMethod.GET)
	@ResponseBody
	@Control(controlPath = "controls/itemBrowser")
	public List<Item> items(@RequestParam(name = "pageNumber", required = false, defaultValue = "0") Integer pageNumber,
			@RequestParam(name = "pageSize", required = false, defaultValue = "0") Integer pageSize, Model model,
			HttpServletRequest request)
	{
		List<Item> items = new ArrayList<>();
		Page<Item> page = iM.Fetch(pageNumber, pageSize);
		
		for(Item i : page)
		{
			items.add(i);
		}

		return items;
	}

	@RequestMapping(value = "/item/itemDetails", method = RequestMethod.GET)
	public String itemDetails(@RequestParam(value = "itemID", required = false) UUID itemID, Model model,
			HttpServletRequest request)
	{
		if (itemID != null)
		{
			Item item = iM.GetItem(itemID);

			if (item != null)
			{
				model.addAttribute("item", item);
			}
		}

		return "itemDetails";
	}
	
	@RequestMapping(value = "/item/itemGallery", method = RequestMethod.GET)
	public String itemGallery(@RequestParam(value = "itemID", required = false) UUID itemID, Model model,
			HttpServletRequest request)
	{
		if (itemID != null)
		{
			Item item = iM.GetItem(itemID);

			if (item != null)
			{
				model.addAttribute("item", item);
			}
		}

		return "/itemGallery/itemGallery";
	}
}
