package com.artstore.controllers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ImageController
{
	@RequestMapping(value = "/image/retrieve", method = RequestMethod.POST)
	public static ResponseEntity<byte[]> retrieveImage(@RequestParam("uid") String uid)
	{
		FileInputStream fis = null;
		
		try
		{
			File file = new File("/images/" + uid);
			
			if(!file.exists())
			{
				return null;
			}
			
			byte[] data = new byte[(int) file.length()];
			
			fis = new FileInputStream(file);			
			fis.read(data, 0, data.length);
			
			final HttpHeaders headers = new HttpHeaders();
		    headers.setContentType(MediaType.IMAGE_PNG);
			
			return new ResponseEntity<byte[]>(data, headers, HttpStatus.CREATED);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			if(fis != null)
			{
				try
				{
					fis.close();
				}
				catch (IOException ex)
				{
					ex.printStackTrace();
				}
			}
		}
		
		return null;
	}
	
	@RequestMapping(value = "/image/upload", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
	public static String uploadImage(@RequestParam("file") MultipartFile file)
	{
		return null;
	}
}
