package com.artstore.controllers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

import com.artstore.controllers.Pack.AccountPack;
import com.artstore.controllers.Pack.ItemPack;
import com.fasterxml.jackson.databind.ObjectMapper;

@Controller
public class FragmentController
{
	private static final ObjectMapper mapper = new ObjectMapper();
	private static Map<String, Class<?>> dataMap = new HashMap<>();
	
	static
	{
		dataMap.put("/admin/accounts :: accountTable", AccountPack.class);
		dataMap.put("/search :: searchItemBrowser", ItemPack.class);
		dataMap.put("/controls/itemBrowser :: searchItemBrowser", ItemPack.class);
	}

	@SuppressWarnings("unchecked")
	@RequestMapping(value = "/frag", method = RequestMethod.POST)
	public ModelAndView fragment(@RequestParam("frag") String frag, @RequestParam("attrs") String attrs, @RequestParam("dt") String dt,  ModelAndView mav) throws IOException, ClassNotFoundException
	{	 
		if(!dataMap.containsKey(frag)) { return null; }
		
		mav.setViewName(frag);
		mav.addObject("data", mapper.readValue(dt, dataMap.get(frag)));
		mav.addAllObjects(mapper.readValue(attrs, Map.class));

		return mav;
	}
}
