package com.artstore.controllers;

import java.util.Locale;

import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.artstore.Core;
import com.artstore.Utils;
import com.artstore.account.Account;
import com.artstore.account.Code;
import com.artstore.managers.IRegistrationManager;

@Controller
public class AuthController extends AbstractController
{
	@Autowired
	public AuthController(Core core)
	{
		super(core);
	}
	
	@RequestMapping(value = "/auth/login", method = RequestMethod.POST, produces = MediaType.TEXT_PLAIN_VALUE)
	@ResponseBody
	public String login(@RequestParam("username") String username, @RequestParam("password") String password, Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{	
		if(Core().GetSessionManager().ValidateSession(session))
		{
			return "already";
		}
		
		Account acc = Core().GetAccountManager().GetAccount(username);
		
		if(acc == null)
		{
			return "false";
		}
		else if(!acc.isActivated())
		{
			return "inactive";
		}
		
		return Core().GetAccountManager().Login(acc, password, session) != null ? "true" : "false";
	
	}
	
	@RequestMapping(value = "/auth/logout", method = RequestMethod.GET)
	public String logout(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{	
		return Utils.Info(Core().GetSessionManager().UnlinkSession(session) ? "Pomyślnie wylogowano" : "Nie można wylogować!",
				model, ra);
	}
	
	@RequestMapping(value = "/auth/recovery1", method = RequestMethod.POST, produces = MediaType.TEXT_PLAIN_VALUE)
	@ResponseBody
	public String recovery1(@RequestParam("email") String email, Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		Account acc = Core().GetAccountManager().GetAccountByMail(email);
		if(acc == null) { return "false"; }
		
		return Core().GetCodeManager().SendCodeMail(Code.Recovery, acc) ? "true" : "sendError";
	}
	
	@RequestMapping(value = "/auth/recovery", method = RequestMethod.GET)
	public String recovery(@RequestParam("account") String account, @RequestParam("code") String code, Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		Account acc = Core().GetAccountManager().GetAccount(account);
		IRegistrationManager rM = Core().GetRegistrationManager();
		
		return Utils.Info(rM.RecoveryAccount(acc, code) ? "Nowe hasło zostało wysłane na skrzynkę mailową!"
				: "Błąd",
				model, ra);
	}
}
