package com.artstore.controllers;

import java.util.ArrayList;
import java.util.Locale;

import javax.servlet.http.HttpSession;
import javax.transaction.Transactional;

import org.apache.commons.validator.routines.EmailValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.artstore.Core;
import com.artstore.account.Account;
import com.artstore.account.InfoAccount;
import com.artstore.controllers.Pack.CurrencyPack;
import com.artstore.controllers.Pack.InfoAccountPack;
import com.artstore.economy.Currency;
import com.artstore.managers.IRegistrationManager.RegResult;

@Controller
public class AdminController extends AbstractController
{
	@Autowired
	private RegistrationController regCon;

	public AdminController(Core core)
	{
		super(core);
	}

	@RequestMapping(value = "/admin", method = RequestMethod.GET)
	public String account(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		return "/admin/admin";
	}

	@RequestMapping(value = "/admin/accounts", method = RequestMethod.GET)
	public String accounts(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		Page<InfoAccount> page = Core().GetAccountManager().Fetch(0, 100);
		InfoAccountPack res = new InfoAccountPack();
		res.setList(page.getContent());
		res.setMaxLength((int) page.getTotalPages());
		model.addAttribute("data", res);

		return "/admin/accounts";
	}

	@RequestMapping(value = "/admin/logs", method = RequestMethod.GET)
	public String logs(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		return "/admin/logs";
	}

	@RequestMapping(value = "/admin/orders", method = RequestMethod.GET)
	public String orders(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		model.addAttribute("list", new ArrayList<Object>());
		model.addAttribute("length", 0);

		return "/admin/orders";
	}

	@RequestMapping(value = "/admin/currencies", method = RequestMethod.GET)
	public String currencies(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		Page<Currency> page = Core().GetEconomyManager().GetCurrencyRepo().findAll(PageRequest.of(0,  100));
		CurrencyPack res = new CurrencyPack();
		res.setList(page.getContent());
		res.setMaxLength((int) page.getTotalPages());
		model.addAttribute("data", res);
		
			return "/admin/currencies";
	}

	@RequestMapping(value = "/admin/accounts/changeType", method = RequestMethod.POST, produces = MediaType.TEXT_PLAIN_VALUE)
	@ResponseBody
	@Transactional
	public String accounts(@RequestParam(value = "username", required = false) String username,
			@RequestParam(value = "accountType", required = false) Integer accountType, Locale locale, Model model,
			HttpSession session)
	{
		System.out.println(username);
		if (username == null)
		{ return "noAccount"; }

		Account acc = Core().GetAccountManager().GetAccount(username);

		if (acc == null)
		{
			return "noAccount";
		}

		acc.setAccountType(accountType);

		return "true";
	}

	@RequestMapping(value = "/admin/accounts/changeMail", method = RequestMethod.POST, produces = MediaType.TEXT_PLAIN_VALUE)
	@ResponseBody
	@Transactional
	public String changeMail(@RequestParam(value = "username", required = false) String username,
			@RequestParam(value = "mail", required = false) String mail, Locale locale, Model model,
			HttpSession session)
	{
		if (username == null)
		{ return "noAccount"; }

		Account acc = Core().GetAccountManager().GetAccount(username);

		if (acc == null)
		{
			return "noAccount";
		}
		else if(!EmailValidator.getInstance().isValid(mail))
		{
			return "invalid";
		}

			acc.setMailbox(mail);

		return "true";
	}
	
	@RequestMapping(value = "/admin/accounts/delAccount", method = RequestMethod.POST, produces = MediaType.TEXT_PLAIN_VALUE)
	@ResponseBody
	@Transactional
	public String delAccount(@RequestParam(value = "username", required = false) String username, Locale locale, Model model,
			HttpSession session)
	{
		if (username == null)
		{ return "DEL_BAD"; }

		Account acc = Core().GetAccountManager().GetAccount(username);

		if (acc == null)
		{
			return "DEL_BAD";
		}

		Core().GetAccountManager().Delete(acc);

		return "DEL_OK";
	}

	@RequestMapping(value = "/admin/accounts/newAccount", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE)
	@ResponseBody
	@Transactional
	public String newAccount(@RequestParam(value = "username") String username,
			@RequestParam(value = "accountType") Integer accountType, @RequestParam(value = "password") String password,
			@RequestParam(value = "mail") String mail, Locale locale, Model model, HttpSession session)
			throws JSONException
	{
		JSONObject res = new JSONObject();
		if (!regCon.Validate(res, username, password, password, mail))
		{
			return res.toString();
		}

		if (RegResult.OK == Core().GetRegistrationManager().RegisterAccount(username, password, mail))
		{
			res.put("resp", "REG_OK");
		}
		else
		{
			res.put("resp", "REG_BAD");

			return res.toString();
		}

		Account acc = Core().GetAccountManager().GetAccount(username);
		acc.setActivated(true);
		acc.setAccountType(accountType);
		Core().GetAccountManager().Update(acc);

		return res.toString();
	}

	@RequestMapping(value = "/admin/settings", method = RequestMethod.GET)
	public String settings(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		return "/admin/settings";
	}
}
