package com.artstore.controllers;

import java.util.Locale;
import java.util.UUID;

import javax.servlet.http.HttpSession;
import javax.transaction.Transactional;

import org.apache.commons.validator.routines.EmailValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.artstore.Core;
import com.artstore.Utils;
import com.artstore.account.Account;
import com.artstore.entity.IEntity;
import com.artstore.item.Item;

@Controller
public class AccountController extends AbstractController
{	
	@Autowired
	public AccountController(Core core)
	{
		super(core);
	}

	@RequestMapping(value = "/account/unauth", method = RequestMethod.GET)
	public String unauth(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		return Utils.Error("Nie jesteś zalogowany!", ra);
	}
	
	@RequestMapping(value = "/account", method = RequestMethod.GET)
	public String account(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		return "/account/account";
	}
	
	@RequestMapping(value = "/account/mailbox", method = RequestMethod.GET)
	public String mailbox(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		return "/account/mailbox";
	}
	
	@RequestMapping(value = "/account/mailbox/newMail", method = RequestMethod.GET)
	public String newMail(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		return "/account/mailbox/newMail";
	}
	
	@RequestMapping(value = "/account/settings", method = RequestMethod.GET)
	public String settings(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{		
		return "/account/settings";
	}
	
	@RequestMapping(value = "/account/settings/changePassword", method = RequestMethod.POST, produces=MediaType.TEXT_PLAIN_VALUE)
	@ResponseBody
	public String changePassword(@RequestParam("newPass") String p0, @RequestParam("newPass2") String p1, Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{		
		if(!p0.equals(p1))
		{
			return "notEqual";
		}
		
		IEntity<UUID> ent = Core().GetSessionManager().GetEntity(session);
		if(!(ent instanceof Account)) { return "false"; }
		
		Account acc = (Account)ent;
		
		return Core().GetAccountManager().SetNewPassword(acc, p0) != null ? "true" : "false";
	}
	
	@RequestMapping(value = "/account/settings/changeMail", method = RequestMethod.POST, produces=MediaType.TEXT_PLAIN_VALUE)
	@ResponseBody
	public String changeMail(@RequestParam("newMail") String newMail, Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{		
		if (!EmailValidator.getInstance().isValid(newMail))
		{
			return "MAIL_PAT";
		}
		
		IEntity<UUID> ent = Core().GetSessionManager().GetEntity(session);
		if(!(ent instanceof Account)) { return "false"; }
		
		Account acc = (Account)ent;
		
		return Core().GetAccountManager().SetNewMail(acc, newMail) ? "true" : "false";
	}
	
	@RequestMapping(value = "/account/settings/changePersonalData", method = RequestMethod.POST, produces=MediaType.TEXT_PLAIN_VALUE)
	@ResponseBody
	public String changePersonalData(@RequestParam("name") String name, @RequestParam("phoneNumber") String phoneNumber, @RequestParam("contactMail") String contactMail, @RequestParam("address") String address, Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{		
		if (name.isEmpty())
		{
			return "EMPTY_NAME";
		}
		else if (!EmailValidator.getInstance().isValid(contactMail))
		{
			return "MAIL_PAT";
		}
		
		IEntity<UUID> ent = Core().GetSessionManager().GetEntity(session);
		if(!(ent instanceof Account)) { return "ACC_TYPE"; }
		
		Account acc = (Account)ent;
		
		return Core().GetAccountManager().SetPersonalData(acc, name, phoneNumber, contactMail, address) ? "TRUE" : "FALSE";
	}
	
	@RequestMapping(value = "/account/cart", method = RequestMethod.GET)
	public String cart(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		Account acc = Core().GetSessionManager().GetAccount(session);
		
		if(acc != null)
		{
			model.addAttribute("cartItems", acc.getCart());
		}
		
		return "/account/cart";
	}
	
	@RequestMapping(value = "/account/orders", method = RequestMethod.GET)
	public static String orders(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{		
		return "/account/orders";
	}
	
	@RequestMapping(value = "/account/payments", method = RequestMethod.GET)
	public static String payments(Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{		
		return "/account/payments";
	}
	
	@RequestMapping(value = "/account/addToCart", method = RequestMethod.POST, produces=MediaType.TEXT_PLAIN_VALUE)
	@ResponseBody
	@Transactional
	public String addToCart(@RequestParam("itemID") UUID itemID, Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		Account acc = Core().GetSessionManager().GetAccount(session);
		Item item = Core().GetItemManager().GetItem(itemID);
		
		if(acc != null && item != null)
		{
			if(acc.IsInCart(item))
			{
				return "ALREADY_IN";
			}
			
			acc.getCart().add(item);
			
			return "OK";
		}
		
		return "BAD";
	}
	
	@RequestMapping(value = "/account/delFromCart", method = RequestMethod.POST, produces=MediaType.TEXT_PLAIN_VALUE)
	@ResponseBody
	@Transactional
	public String delFromCart(@RequestParam("itemID") UUID itemID, Locale locale, Model model, HttpSession session, RedirectAttributes ra)
	{
		Account acc = Core().GetSessionManager().GetAccount(session);
		
		if(acc != null)
		{			
			for(Item i : acc.getCart())
			{
				if(i.getId().equals(itemID))
				{
					acc.getCart().remove(i);
					
					return "OK";
				}
			}
			
			return "NOT_IN";
		}
		
		return "BAD";
	}
}
