package com.artstore.config.interceptors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.web.servlet.HandlerInterceptor;

import com.artstore.Core;
import com.artstore.ILinked;

public class HttpSessionInterceptor implements HandlerInterceptor, ILinked
{
	private Core core;
	
	public HttpSessionInterceptor(Core core)
	{
		this.core = core;
	}
	
	public Core Core()
	{
		return core;
	}
	
	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception
	{
		updateSession(request.getSession());
		return true;
	}

	private void updateSession(HttpSession session)
	{
			if (Core().GetSessionManager().ValidateSession(session))
			{
				Core().GetSessionManager().RefreshSessionLinkage(session);

				session.setAttribute("isLogged", true);
			} else
			{
				session.setAttribute("isLogged", false);
			}
	}
}
