package com.artstore.config.interceptors;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/*
 * Informs that data returned by that controller's method has it's dedicated representation .html file.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Control
{
	/*
	 * Returns path to .html file which consists of HTML that is representation of returned data.
	 */
	public String controlPath();
}
