package com.artstore.config.interceptors;

import java.lang.reflect.Method;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import com.artstore.Core;
import com.artstore.ILinked;
import com.artstore.account.Account;
import com.artstore.entity.IAccessEntity;
import com.artstore.entity.IEntity;
import com.artstore.managers.ISessionManager;

public class AuthInterceptor implements HandlerInterceptor, ILinked
{
	protected Core core;

	public AuthInterceptor(Core core)
	{
		this.core = core;
	}

	public Core Core()
	{
		return core;
	}

	@Override
	public boolean preHandle(HttpServletRequest req, HttpServletResponse resp, Object handler) throws Exception
	{
		ISessionManager<UUID> sM = Core().GetSessionManager();

		HttpSession session = req.getSession(false);
		IEntity<UUID> ent = sM.GetEntity(session);
if(ent != null && ent instanceof Account) { ent = Core().GetAccountManager().GetAccount(ent.GetID());session.setAttribute("ent", ent); }
		if (req.getServletPath().startsWith("/account") && !sM.ValidateSession(session))
		{
			resp.sendRedirect(resp.encodeRedirectURL("/unauth"));

			return false;
		}
		else if(req.getServletPath().startsWith("/worker") && (!sM.ValidateSession(session) || ent == null || !(ent instanceof Account) || ((Account)ent).getAccountType() < 1))
		{
			resp.sendRedirect(resp.encodeRedirectURL("/unauth"));

			return false;
		}
		else  if(req.getServletPath().startsWith("/admin") && (!sM.ValidateSession(session) || ent == null || !(ent instanceof Account) || ((Account)ent).getAccountType() < 2))
		{
			resp.sendRedirect(resp.encodeRedirectURL("/unauth"));

			return false;
		}
		
		if(!Annotation(session, handler))
		{
			resp.sendRedirect(resp.encodeRedirectURL("/unauth"));
			
			return false;
		}

		return true;
	}

	protected boolean Annotation(HttpSession session, Object handler)
	{
		if (!(handler instanceof HandlerMethod))
		{
			return true;
		}

		Method method = ((HandlerMethod) handler).getMethod();
		
		AuthLevel authAnn = method.getAnnotation(AuthLevel.class);
		if (authAnn == null)
		{
			return true;
		}
		
		IEntity<UUID> ent = Core().GetSessionManager().GetEntity(session);
		if(ent == null || !(ent instanceof IAccessEntity))
		{
			return true;
		}
		
		if(authAnn.accessLevel() < ((IAccessEntity<UUID>)ent).GetAccessLevel())
		{
			return false;
		}

		return true;
	}
}
