package com.artstore.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import com.artstore.Core;
import com.artstore.ILinked;
import com.artstore.config.interceptors.AuthInterceptor;
import com.artstore.config.interceptors.HttpSessionInterceptor;

@Component
public class InterceptorConfig implements WebMvcConfigurer, ILinked
{
	private Core                         core;

	@Autowired
	public InterceptorConfig(Core core)
	{
		this.core = core;
	}

	public Core Core()
	{
		return core;
	}

	@Override
	public void addInterceptors(InterceptorRegistry registry)
	{
		registry.addInterceptor(new HttpSessionInterceptor(Core()));
		registry.addInterceptor(new AuthInterceptor(Core()));
	}
}