package com.artstore.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;

import com.artstore.config.interceptors.Control;

@ControllerAdvice
public class ControlAdvice implements ResponseBodyAdvice<Object>
{	
	@Autowired
	private ThymeleafViewResolver res;
	
	@Override
	public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType)
	{
		return returnType.getMethod().isAnnotationPresent(Control.class);
	}

	@Override
	public Object beforeBodyWrite(Object obj, MethodParameter returnType,
			MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType,
			ServerHttpRequest request, ServerHttpResponse response)
	{
		String controlPath = returnType.getMethod().getAnnotation(Control.class).controlPath();
		
		if(request.getHeaders().getContentType() == null || request.getHeaders().getContentType().includes(MediaType.TEXT_HTML))
		{
			try
			{
				request.getHeaders().setContentType(MediaType.TEXT_HTML);
				response.getHeaders().setContentType(MediaType.TEXT_HTML);
				
				View controlView = res.resolveViewName(controlPath, Locale.getDefault());
				MockHttpServletRequest mockReq = new MockHttpServletRequest();
				MockHttpServletResponse mockResp = new MockHttpServletResponse();
				
				Map<String, Object> map = new HashMap<String, Object>();
				map.put("controlData", obj);
				
				controlView.render(map, mockReq, mockResp);
				
				return mockResp.getContentAsString();
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		
		return obj;
	}
}