package com.artstore.account;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class SecurityUtils
{
	private static final SecureRandom sr = new SecureRandom();

	public static byte[] GenerateSalt(int length)
	{
		byte[] salt = new byte[length];

		for (int i = 0; i < length; i++)
		{
			salt[i] = (byte) (33 + (sr.nextInt() % 94));
		}

		return salt;
	}
	
	public static byte[] GenerateSalt()
	{
		return GenerateSalt(8);
	}

	public static byte[] Hash(byte[] data, byte[] salt)
	{
		try
		{
			MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
			messageDigest.update(salt);

			return messageDigest.digest(data);
		}
		catch (NoSuchAlgorithmException e)
		{
			e.printStackTrace();
		}

		return null;
	}

	public static byte[] Hash(String s, byte[] salt)
	{
		return Hash(s.getBytes(StandardCharsets.UTF_8), salt);
	}

	public static String ToHex(byte[] data)
	{
		StringBuilder sb = new StringBuilder();

		for (int i = 0; i < data.length; i++)
		{
			sb.append(Integer.toString((data[i] & 0xff) + 0x100, 16).substring(1));
		}

		return sb.toString();
	}

	public static boolean ValidatePassword(String password, byte[] salt, byte[] hash)
	{
		byte[] currHash = Hash(password, salt);
		
		if(currHash.length != hash.length) { return false; }

		for (int i = 0; i < currHash.length; i++)
		{
			if(currHash[i] != hash[i]) { return false; }
		}
		
		return true;
	}
}
