package com.artstore.account;

import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

import com.artstore.permissions.IPermission;
import com.artstore.permissions.uuid.UUIDPermissibleGroup;

@Entity
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
@Table(name = "`groups`")
public class Group extends UUIDPermissibleGroup<UUID>
{
	private static final long serialVersionUID = 3760544663846994986L;

	public Group(UUID id, String name, String description)
	{
		super(id, name, description);
	}

	public Group()
	{
	}
	
	public static Group Create(String name, String desc, IPermission... perms)
	{
		Group res = new Group();
		res.setName(name);
		res.setDescription(desc);
		
		for(IPermission perm : perms)
		{
			res.Grant(perm);
		}
		
		return res;
	}


	@Column(name = "name", updatable = true, nullable = false)
	public String getName()
	{
		return GetName();
	}

	public void setName(String name)
	{
		this.name = name;
	}

	@Column(name = "description", updatable = true, nullable = true)
	public String getDescription()
	{
		return GetDescription();
	}

	public void setDescription(String description)
	{
		this.description = description;
	}
}
