package com.artstore.account;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.artstore.Core;
import com.artstore.managers.AbstractManager;

@Component
public class CodeManager extends AbstractManager
{
	public static interface CodeGenerator
	{
		public String Generate(Account acc);
	}
	
	@Autowired
	public CodeManager(Core core)
	{
		super(core);
	}
	
	public String Hyperlink(Code code, Account acc)
	{
		String link = code.GenerateLink(acc, Core().GetServerWWWLink());
		
		return "<a href=\"" + link + "\">" + link + "</a>";
	}

	public boolean SendCodeMail(Code code, Account acc)
	{
		System.out.println(Hyperlink(code, acc));
		return Core().GetMailManager().SendMail("art.store.art.store@gmail.com", acc.getMailbox(),
				"Art Store " + code.getMailSubject(),
				String.format(code.getMailContent(), Hyperlink(code, acc)));
	}
	
	public boolean Verify(Code code, Account acc, String receivedCode)
	{
		return Verify(code.Generate(acc), receivedCode);
	}
	
	public boolean Verify(String code0, String code1)
	{
		return code0.equalsIgnoreCase(code1);
	}
}
