package com.artstore.account;

import com.artstore.account.CodeManager.CodeGenerator;

public enum Code
{
	Activation("Kod Aktywacyjny", "Link z kodem aktywacyjnym: %s", "/registration/activate", new CodeGenerator()
	{
		public String Generate(Account acc)
		{
			return SecurityUtils.ToHex(SecurityUtils.Hash(acc.getPassword(), acc.getUsername().getBytes()));
		}
	}),
	Recovery("Odzyskiwanie hasła",
			"Po kliknięciu w podany poniżej link, otrzymasz wiadomość mailową z nowym hasłem: %s", "/auth/recovery",
			new CodeGenerator()
			{
				public String Generate(Account acc)
				{
					byte[] psswd = acc.getPassword();
					byte[] ar = new byte[psswd.length];

					for(int i = 0;i < psswd.length;i++)
					{
						ar[i] = (byte) (2 * psswd[i]);
					}
					
					return SecurityUtils.ToHex(SecurityUtils.Hash(ar, acc.getUsername().getBytes()));
				}
			});

	String        mailSubject;
	String        mailContent;
	String        defaultSubsite;
	CodeGenerator generator;

	private Code(String mailSubject, String mailContent, CodeGenerator generator)
	{
		this(mailSubject, mailContent, null, generator);
	}

	Code(String mailSubject, String mailContent, String defaultSubsite, CodeGenerator generator)
	{
		this.mailSubject = mailSubject;
		this.mailContent = mailContent;
		this.defaultSubsite = defaultSubsite;
		this.generator = generator;
	}

	public String getMailSubject()
	{
		return mailSubject;
	}

	public String getMailContent()
	{
		return mailContent;
	}

	public CodeGenerator getGenerator()
	{
		return generator;
	}

	public String Generate(Account acc)
	{
		return generator.Generate(acc);
	}

	public String GenerateLink(Account acc, String serverWWWLink)
	{
		return GenerateLink(acc, serverWWWLink, defaultSubsite);
	}

	public String GenerateLink(Account acc, String serverWWWLink, String subSite)
	{
		return serverWWWLink + subSite + "?account=" + acc.getUsername() + "&code=" + Generate(acc);
	}
}