package com.artstore.account;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Email;

import org.hibernate.annotations.CreationTimestamp;

import com.artstore.item.Item;
import com.artstore.permissions.uuid.UUIDPermissibleEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;

@Entity
@Table(name="accounts")
public class Account extends UUIDPermissibleEntity implements Serializable
{
	private static final long serialVersionUID = -659180091212557800L;
	
	@Column(nullable = false, unique = true)
	private String	username;

	@Column(nullable = false)
	private byte[]	password;
	
	@Column(nullable = false)
	private byte[]	passwordSalt;
	
	private boolean isActivated = false;

	@Column(nullable = false)
	@CreationTimestamp
	private Date	creationDate;
	
	@Email
	private String mailbox;
	
	@Column(nullable = false)
	private int accountType = 0;
	
	private String				name;
	
	@Column(nullable = true)
	private String				phoneNumber;	
	private String				contactMailbox;
	private String				address;
	
	@OneToMany(targetEntity=Item.class,fetch=FetchType.EAGER, cascade = {CascadeType.ALL})
	private List<Item> cart = new ArrayList<Item>();
	
	public Account()
	{
		super(null);
	}
	
	public static Account Create(String username, String password, String mail)
	{
		Account res = new Account();
		byte[] salt = SecurityUtils.GenerateSalt();
		byte[] psswd = SecurityUtils.Hash(password, salt);

		res.setUsername(username);
		res.setPassword(psswd);
		res.setPasswordSalt(salt);
		res.setMailbox(mail);
		
		return res;
	}
	
	public UUID getId()
	{
		return GetID();
	}
	
	public void setId(UUID id)
	{
		SetID(id);
	}

	public String getUsername()
	{
		return username;
	}

	public void setUsername(String username)
	{
		this.username = username;
	}

	public byte[] getPassword()
	{
		return password;
	}

	public void setPassword(byte[] password)
	{
		this.password = password;
	}

	public byte[] getPasswordSalt()
	{
		return passwordSalt;
	}

	public void setPasswordSalt(byte[] passwordSalt)
	{
		this.passwordSalt = passwordSalt;
	}

	public boolean isActivated()
	{
		return isActivated;
	}

	public void setActivated(boolean isActivated)
	{
		this.isActivated = isActivated;
	}

	public Date getCreationDate()
	{
		return creationDate;
	}

	public void setCreationDate(Date creationDate)
	{
		this.creationDate = creationDate;
	}

	public String getMailbox()
	{
		return mailbox;
	}

	public void setMailbox(String mailbox)
	{
		this.mailbox = mailbox;
	}

	public int getAccountType()
	{
		return accountType;
	}

	public void setAccountType(int accountType)
	{
		this.accountType = accountType;
	}
	
	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public String getPhoneNumber()
	{
		return phoneNumber;
	}

	public void setPhoneNumber(String phoneNumber)
	{
		this.phoneNumber = phoneNumber;
	}

	public String getContactMailbox()
	{
		return contactMailbox;
	}

	public void setContactMailbox(String contactMailbox)
	{
		this.contactMailbox = contactMailbox;
	}

	public String getAddress()
	{
		return address;
	}

	public void setAddress(String address)
	{
		this.address = address;
	}

	public List<Item> getCart()
	{
		return cart;
	}

	public void setCart(List<Item> cart)
	{
		this.cart = cart;
	}

	@JsonIgnore
	@Override
	public boolean isWorker()
	{
		return 1 <= accountType;
	}
	
	@JsonIgnore
	public boolean isAdmin()
	{
		return 2 <= accountType;
	}
	
	public boolean IsInCart(Item item)
	{
		for(Item i : cart)
		{
			if(item.getId().equals(i.getId()))
			{
				return true;
			}
		}
		
		return false;
	}
}
