package com.artstore;

import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import com.artstore.config.ExternalConfigUtils;
import com.artstore.controllers.NavController;

@EnableConfigurationProperties({ com.artstore.config.PersistenceContext.class })
@Import({ com.artstore.config.PersistenceContext.class })
@SpringBootApplication
@ServletComponentScan
@EnableTransactionManagement
public class ArtStoreApplication
{
	public static final int                           GLOBAL_STATUS_CORRUPTION_ID   = -666;
	public static final String                        GLOBAL_STATUS_CORRUPTION_DESC = "Unit data corrupted";

	public static ConfigurableApplicationContext context;

	public static void main(String[] args)
	{
		context = new SpringApplicationBuilder(ArtStoreApplication.class).properties(ExternalConfigUtils.GetProperties("server")).build().run(args);
		
		context.getBean(Core.class).Initialize(context);
		
		NavController.core = context.getBean(Core.class);
	}
}
